<?php

/**
 * Class Bonica
 */
class Bonica extends WpPlugin
{
    const BONICA_APIKEY = 'bonica_apikey';
    const BONICA_DEBUG_MODE = 'bonica_debug_mode';
    const BONICA_AUTH_SUCCESS = 'bonica_auth_success';

    public $options = [
        self::BONICA_APIKEY => '',
        self::BONICA_AUTH_SUCCESS => 0
    ];


    public function activate()
    {
        parent::activate();
        $this->generate_apikey();
    }

    /**
     * @return bool|string
     */
    public function generate_apikey()
    {
        return $this->rand_sha1(40);
    }

    public function setApiKey($key)
    {
        update_option(self::BONICA_APIKEY, $key);
    }

    public function setDebugMode($value)
    {
        update_option(self::BONICA_DEBUG_MODE, (boolean)$value);
    }

    /**
     * @param $length
     * @return bool|string
     */
    protected function rand_sha1($length)
    {
        $max = ceil($length / 40);
        $random = '';
        for ($i = 0; $i < $max; $i++) {
            $random .= sha1(microtime(true) . mt_rand(10000, 90000));
        }
        return substr($random, 0, $length);
    }

    function meta()
    {
        global $post;
        if (!is_singular()) {
            return;
        }

        $description = get_post_meta($post->ID, 'seo_description', true);
        if ($description) {
            echo "<meta name='description' content='{$description}' />\n";
        }
        $keywords = get_post_meta($post->ID, 'seo_keywords', true);
        if ($keywords) {
            echo "<meta name='keywords' content='{$keywords}' />\n";
        }
    }
}
