<?php

/**
 * Class BonicaAdmin
 */
class BonicaAdmin extends Bonica
{
    public $title = 'Bonica';
    public $menu = 'Настройки Bonica';
    public $capability = 'manage_options';
    public $slug = 'bonica';

    /**
     * @return string
     */
    public function options()
    {
        if (isset($_POST['updateapikey2'])) {
            $apikey = $this->generate_apikey();
            $this->setApiKey($apikey);
        }
        if ($_POST) {
            $this->setDebugMode(isset($_POST['debug-mode']));
        }
        $apikey = get_option(Bonica::BONICA_APIKEY);
        $debugMode = get_option(Bonica::BONICA_DEBUG_MODE);
        return $this->render('options', ['apikey' => $apikey, 'debugMode' => $debugMode]);
    }
}