<?php

/**
 * Class BonicaPluginAutoUpdate
 */
class BonicaPluginAutoUpdate
{
    # URL to check for updates, this is where the index.php script goes
    public $api_url;

    # Type of package to be updated
    public $package_type;

    public $plugin_slug;
    public $plugin_file;

    /**
     * BonicaPluginAutoUpdate constructor.
     *
     * @param $api_url
     * @param $type
     * @param $slug
     */
    public function __construct($api_url, $type, $slug)
    {
        $this->api_url = $api_url;
        $this->package_type = $type;
        $this->plugin_slug = $slug;
        $this->plugin_file = $slug . '/bonica-plugin.php';

        add_filter('pre_set_site_transient_update_plugins', [&$this, 'check_for_plugin_update']);
        add_filter('plugins_api', [&$this, 'plugins_api_call'], 10, 3);
    }

    /**
     * @param $request
     * @return mixed
     */
    public function check_for_plugin_update($request)
    {
        if (!isset($request->checked[$this->plugin_file])) {
            return $request;
        }
        $request_args = [
            'slug' => $this->plugin_slug,
            'version' => $request->checked[$this->plugin_file],
            'package_type' => $this->package_type,
        ];
        $request_string = $this->prepare_request('basic_check', $request_args);
        $raw_response = wp_remote_post($this->api_url, $request_string);
        if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200)) {
            $response = unserialize($raw_response['body']);
            if (is_object($response) && !empty($response))
                $request->response[$this->plugin_file] = $response;
        }
        return $request;
    }

    /**
     * Используется для фильтра plugins_api, $def - всегда false
     *
     * @param $def
     * @param $action
     * @param $args
     * @return bool|mixed|WP_Error
     */
    public function plugins_api_call($def, $action, $args)
    {
        if (!isset($args->slug) || $args->slug != $this->plugin_slug) {
            return false;
        }
        $plugin_info = get_site_transient('update_plugins');
        $current_version = $plugin_info->checked[$this->plugin_file];
        $args->version = $current_version;
        $args->package_type = $this->package_type;
        $request_string = $this->prepare_request($action, $args);
        $request = wp_remote_post($this->api_url, $request_string);
        if (is_wp_error($request)) {
            $res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $request->get_error_message());
        } else {
            $res = unserialize($request['body']);
            if ($res === false) {
                $res = new WP_Error('plugins_api_failed', __('An unknown error occurred'), $request['body']);
            }
        }
        return $res;
    }

    /**
     * @param $action
     * @param $args
     * @return array
     */
    public function prepare_request($action, $args)
    {
        global $wp_version;

        $site_url = site_url();

        $wp_info = [
            'site-url' => $site_url,
            'version' => $wp_version, // версия WP, глобальная
        ];

        return [
            'body' => [
                'action' => $action,
                'request' => serialize($args),
                'wp-info' => serialize($wp_info),
            ]
        ];
    }
}