<?php


abstract class WpPlugin
{
    public $title = 'WP Plugin';
    public $menu = 'Plugin options';
    public $capability = 'manage_options';
    public $slug = 'plugin';
    public $options;

    /**
     * @param $view
     * @param array $params
     * @param bool $return
     * @return string
     * @throws Exception
     * @throws Throwable
     */
    public function render($view, $params = [], $return = false)
    {
        $_obInitialLevel_ = ob_get_level();
        ob_start();
        ob_implicit_flush(false);
        extract($params, EXTR_OVERWRITE);
        try {
            require(BONICA_PLUGIN_DIR_VIEWS . $view . '.php');
            $content = ob_get_clean();
            if ($return) {
                return $content;
            } else {
                echo $content;
            }
        } catch (\Exception $e) {
            while (ob_get_level() > $_obInitialLevel_) {
                if (!@ob_end_clean()) {
                    ob_clean();
                }
            }
            throw $e;
        } catch (\Throwable $e) {
            while (ob_get_level() > $_obInitialLevel_) {
                if (!@ob_end_clean()) {
                    ob_clean();
                }
            }
            throw $e;
        }
        return null;
    }

    /**
     * WpPlugin constructor.
     */
    public function __construct()
    {
        register_activation_hook(__FILE__, [&$this, 'activate']);
        add_action('wp_head', [&$this, 'meta']);
        add_action('admin_menu', [&$this, 'admin_menu']);
    }

    public function activate()
    {
        foreach ($this->options as $key => $option) {
            add_option($key, $option);
        }
    }

    public function admin_menu()
    {
        add_options_page($this->title, $this->menu, $this->capability, $this->slug, [&$this, 'options']);
    }

    /**
     * @return string
     */
    public function options()
    {
        return $this->render('options');
    }

    abstract function meta();
}