<?php
/**
 * Plugin Name: Bonica posts
 * Plugin URI:  https://bonica.pro/wordpress
 * Description: Импорт статей из Bonica.
 * Author: Bonica
 * Author URI: https://bonica.pro
 * Version: 0.0.29
 */

define('BONICA_PLUGIN_UPDATE_URL', 'https://bonica.pro/wordpress/update');
define('BONICA_PLUGIN_PATH', dirname(__FILE__));
define('BONICA_PLUGIN_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);
define('BONICA_PLUGIN_DIR_SRC', BONICA_PLUGIN_DIR . 'src' . DIRECTORY_SEPARATOR);
define('BONICA_PLUGIN_DIR_VIEWS', BONICA_PLUGIN_DIR . 'views' . DIRECTORY_SEPARATOR);

if (!class_exists('IXR_Server')) {
    include_once(ABSPATH . WPINC . '/class-IXR.php');
}

if (!class_exists('wp_xmlrpc_server')) {
    include_once(ABSPATH . WPINC . '/class-wp-xmlrpc-server.php');
}

spl_autoload_register(function ($class) {
    $classFile = BONICA_PLUGIN_DIR_SRC . $class . '.php';
    if (file_exists($classFile)) {
        include $classFile;
    }
});


include_once BONICA_PLUGIN_PATH . DIRECTORY_SEPARATOR . 'vendor/autoload.php';

$checker = Puc_v4_Factory::buildUpdateChecker('https://bonica.pro/wordpress/details.json', __FILE__, 'wp-bonica');

new BonicaPluginAutoUpdate(BONICA_PLUGIN_UPDATE_URL, 'stable', 'wp-bonica');

if (defined('WP_CLI') && WP_CLI) {
    $tokenGen = function ($args, $assoc_args) {
        $bonica = new BonicaAdmin();
        $apikey = $bonica->generate_apikey();
        $bonica->setApiKey($apikey);
        WP_CLI::success("New token generated: $apikey");
    };
    WP_CLI::add_command('generate-bonica-token', $tokenGen, ['shortdesc' => 'Generate new token for bonica.pro']);
}

$bonica = is_admin() ? new BonicaAdmin() : new Bonica();
