<?php


abstract class Meta
{
    public $plugins = [];
    public $title;
    public $description;
    public $keywords;

    public function checkPlugin()
    {
        if (!$this->plugins) {
            return true;
        }
        $plugins = get_plugins();
        foreach ($plugins as $file => $plugin) {
            if (is_plugin_active($file) && in_array($plugin['Name'], $this->plugins)) {
                return true;
            }
        }
        return false;
    }

    protected static function _setMeta($id, $name, $value)
    {
        $instance = static::getInstance();
        if ($instance->checkPlugin()) {
            if (get_post_meta($id, $name, true)) {
                update_post_meta($id, $name, $value);
            } else {
                add_post_meta($id, $name, $value, true);
            }
            return true;
        } else {
            return false;
        }
    }

    public static function setTitle($id, $title)
    {
        self::_setMeta($id, static::getInstance()->title, $title);
    }

    public static function setDescription($id, $title)
    {
        self::_setMeta($id, static::getInstance()->description, $title);
    }

    public static function setKeywords($id, $title)
    {
        self::_setMeta($id, static::getInstance()->keywords, $title);
    }

    public static function setMeta($id, $title, $description)
    {
        static::setTitle($id, $title);
        static::setDescription($id, $description);
    }

    public static function getMeta($id, $name)
    {
        return get_post_meta($id, $name, true);
    }

    public static function getTitle($id)
    {
        if (static::getInstance()->checkPlugin()) {
            return static::getMeta($id, static::getInstance()->title);
        } else {
            return null;
        }
    }

    public static function getDescription($id)
    {
        if (static::getInstance()->checkPlugin()) {
            return static::getMeta($id, static::getInstance()->description);
        } else {
            return null;
        }
    }

    public static function getKeywords($id)
    {
        return static::getMeta($id, static::getInstance()->keywords);
    }

    /**
     * @return static
     */
    public static function getInstance()
    {
        return new static();
    }
}
